# Modified implementation of CAW [Wang et al. (2021)]

This is a modified implementation of CAW. The changes are three-fold:

* Fix the dimension error in the MultiHeadAttention layer in __transformer.py__ (using the `--fix_attn` flag).
* Change the transductive setting to follow the configuration for TGN [Rossi et al. (2020)] and TGAT [Xu et al. (2020)]. 
More precisely, the model is only trained on the non-masked nodes in the training set instead of the complete training set.
* Add the `WALK_POOL` argument when calling the CAW object to effectively allow different walk pooling operators.

For example, the following commands execute the modified CAW with the new hyperparameters (by model selection):

1. Reddit
    ```
    python main.py -d reddit --pos_dim 108 --n_degree 32 1 1 --n_layer 3  --bias 1e-8  --fix_attn --prefix caw_modified --seed 0
    ```

2. Wikipedia
    ```
    python main.py -d wikipedia --pos_dim 108 --n_degree 64 1 1 1 --n_layer 4  --bias 4e-6  --fix_attn --prefix caw_modified --seed 0
    ```

3. MOOC
    ```
   python main.py -d mooc --pos_dim 100 --n_degree 64 1 1 --n_layer 3 --bias 1e-4 --fix_attn --prefix caw_modified --seed 0
    ```

4. UCI
    ```
   python main.py -d uci --pos_dim 100 --n_degree 64 1 --n_layer 2 --bias 1e-5 --fix_attn --prefix caw_modified --seed 0
    ```


For more details, please see the original implementation in [CAW's repository](https://github.com/snap-stanford/CAW).
